/////////////////////////////////////////////////////////////////////////////
//
// LightingView.cpp : implementation of the CLightingView class
//
/////////////////////////////////////////////////////////////////////////////


#include "stdafx.h"
#include "Lighting.h"

#include "LightingDoc.h"
#include "LightingView.h"

#include <math.h> // for fabs()

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


/////////////////////////////////////////////////////////////////////////////
// CLightingView

IMPLEMENT_DYNCREATE(CLightingView, COpenGLView)

BEGIN_MESSAGE_MAP(CLightingView, COpenGLView)
	//{{AFX_MSG_MAP(CLightingView)
		// NOTE - the ClassWizard will add and remove mapping macros here.
		//    DO NOT EDIT what you see in these blocks of generated code!
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CLightingView construction/destruction

/////////////////////////////////////////////////////////////////////////////
CLightingView::CLightingView()
{
	// TODO: add construction code here

	// set the initial position & rotation
	m_Z = -9.0;
	m_rotY = 35.0;
	m_rotX = 25.0f;

	ToggleAnimationFlag(); // enable animation

	SelectStockScene(eStockSceneNone);
	
}

/////////////////////////////////////////////////////////////////////////////
// Control the animation
BOOL CLightingView::PreRenderScene( void )
{
	// toggle the velocity in the Z direction
	if ( m_Z <= -19.0  )
		{
		m_accelZ = fabs(m_accelZ);
		}
	else if (  m_Z >= -3.0 )
		{
		m_accelZ = -fabs(m_accelZ);
		}

	return ViewpointOriginRotation();
}

/////////////////////////////////////////////////////////////////////////////
// Set up the material properties here
void CLightingView::OnInitialUpdate() 
{
	CView::OnInitialUpdate();
	
	// TODO: Add your specialized code here and/or call the base class

	// Set the the material properties
    GLfloat ambient[] = { 0.2f, 0.2f, 0.2f, 1.0f };
    GLfloat diffuse[] = { 0.8f, 0.8f, 0.8f, 1.0f };
    GLfloat position[] = { 0.0f, 5.0f, 0.0f, 0.0f };

	// enable all the lighting & depth effects
    ::glEnable( GL_DEPTH_TEST );
    ::glDepthFunc( GL_LESS );
    ::glEnable( GL_LIGHT0 );

    ::glLightfv( GL_LIGHT0, GL_AMBIENT, ambient );
    ::glLightfv( GL_LIGHT0, GL_POSITION, position );
    ::glLightfv( GL_LIGHT0, GL_DIFFUSE, diffuse );

	// select the color for non-lighted things, in this case the text
	::glColor3f( 0.8f, 0.8f, 0.2f ); // yellow text
}


/////////////////////////////////////////////////////////////////////////////
BOOL CLightingView::RenderScene( void )
{
	// set up arrays of various properties
	// placed here for convenience
	GLfloat materialSpecular[4][4] = {
		{ 0.1f,  0.1f,  0.1f, 1.0f },
		{ 0.33f, 0.33f, 0.33f, 1.0f },
		{ 0.67f, 0.67f, 0.67f, 1.0f },
		{ 0.9f,  0.9f,  0.9f,  1.0f },
		};

	GLfloat materialAmbDiff[4][4] ={
		{ 0.0f, 0.0f, 0.12f, 1.0f },
		{ 0.0f, 0.0f, 0.25f, 1.0f },
		{ 0.0f, 0.0f, 0.50f, 1.0f },
		{ 0.0f, 0.0f, 1.00f, 1.0f },
		};

	GLfloat materialShininess[4][1] = {
		{ 0.0f },
		{ 35.0f },
		{ 70.0f },
		{ 128.0f }
		};

	// Don't let the text get lighting effects
	::glDisable( GL_LIGHTING );

	// along the X axis
	::glPushMatrix();
	::glTranslatef( -1.5f, 2.0f, -1.5f );
	::glScalef( 0.6f, 0.6f, 1.0f );
	GLTextOut( m_DefaultTextID, "SHININESS->" );
	::glPopMatrix();

	// along the Y axis
	::glPushMatrix();
	::glTranslatef( -1.5f, -1.5f, -1.5f );
	::glRotatef( 90.0f, 0.0f, 0.0f, 1.0f );
	::glTranslatef( 0.0f, 0.5f, 0.0f );
	::glScalef( 0.4f, 0.6f, 1.0f );
	GLTextOut( m_DefaultTextID, "DIFFUSE & AMBIENT->" );
	::glPopMatrix();

	// along the Z axis
	::glPushMatrix();
	::glTranslatef( 2.0f, 2.0f, -1.5f );
	::glRotatef( -90.0f, 0.0f, 1.0f, 0.0f );
	::glScalef( 0.6f, 0.6f, 1.0f );
	GLTextOut( m_DefaultTextID, "SPECULAR->" );
	::glPopMatrix();
	::glEnable( GL_LIGHTING ); // turn lighting back on

	// now draw the matrix of spheres
	::glPushMatrix();
	for (int z = 0 ; z < 4 ; z++)
		{
		::glMaterialfv( GL_FRONT, GL_SPECULAR, materialSpecular[z] );
		for (int y = 0 ; y < 4 ; y++)
			{
			::glMaterialfv( GL_FRONT, GL_AMBIENT_AND_DIFFUSE, materialAmbDiff[y] );
			for ( int x = 0 ; x < 4 ; x++ )
				{
				::glMaterialfv( GL_FRONT, GL_SHININESS, materialShininess[x] );
				::glPushMatrix();
				::glTranslatef( -1.5f+(float)x, -1.5f+(float)y, -1.5f+(float)z );
				::auxSolidSphere( 0.25f );
				::glPopMatrix();
				}
			}
		}
	::glPopMatrix();

	return TRUE;
}

/////////////////////////////////////////////////////////////////////////////
CLightingView::~CLightingView()
{
}
